% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_plot.R
\name{ssm_plot_curve}
\alias{ssm_plot_curve}
\title{Create a Curve Plot of SSM Results}
\usage{
ssm_plot_curve(
  ssm_object,
  angle_labels = NULL,
  base_size = 11,
  drop_lowfit = FALSE,
  ...
)
}
\arguments{
\item{ssm_object}{Required. The results output of \code{ssm_analyze()}.}

\item{angle_labels}{Optional. Either NULL or a character vector that
determines the x-axis labels. If NULL, the labels will be the angle
numbers. If a character vector, must be the same length and in the same
order as the \code{angles} argument to \code{ssm_analyze()} (default = NULL).}

\item{base_size}{Optional. A positive number corresponding to the base font
size in pts (default = 11).}

\item{drop_lowfit}{Optional. A logical indicating whether to omit profiles with
low fit (<.70) or include them with dashed lines (default = FALSE).}

\item{...}{Additional arguments will be ignored.}
}
\value{
A ggplot object depicting the SSM curve(s) of each profile.
}
\description{
Take in the results of a Structural Summary Method analysis and plot the
scores by angle and the estimated SSM curve.
}
\examples{
\donttest{
data("jz2017")
res <- ssm_analyze(
  jz2017,
  scales = 2:9,
  measures = 10:13
)
ssm_plot_curve(res)
ssm_plot_curve(res, angle_lables = PANO())
}
}
