% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{expand}
\alias{expand}
\title{Expand Count Data into Binary Vectors}
\usage{
expand(x, n)
}
\arguments{
\item{x}{Integer (or vector of integers) representing the number of successes.}

\item{n}{Integer (or vector of integers) representing the total number of participants.}
}
\value{
A logical vector where TRUE represents a success and FALSE represents a failure.
The length of the vector equals the sum of all sample sizes.
}
\description{
Converts count data (number of successes and total sample size) into a binary vector
of TRUE/FALSE values. This is useful for converting summary statistics back into
raw data format for analysis functions that require individual-level data.
}
\details{
For each pair of values in \code{x} and \code{n}, the function creates a vector with \code{x} TRUE values
followed by \code{n-x} FALSE values. If multiple pairs are provided, the resulting vectors are
concatenated in order.
}
\examples{
# Convert 4 successes out of 13 participants to binary data
expand(4, 13)

# Convert multiple groups of data
# Group 1: 9 successes out of 10
# Group 2: 3 successes out of 10
expand(c(9, 3), c(10, 10))

}
