% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMultiClass.R
\name{checkMultiClass}
\alias{checkMultiClass}
\alias{check_multi_class}
\alias{assertMultiClass}
\alias{assert_multi_class}
\alias{testMultiClass}
\alias{test_multi_class}
\alias{expect_multi_class}
\title{Check the class membership of an argument}
\usage{
checkMultiClass(x, classes, null.ok = FALSE)

check_multi_class(x, classes, null.ok = FALSE)

assertMultiClass(x, classes, null.ok = FALSE, .var.name = vname(x), add = NULL)

assert_multi_class(
  x,
  classes,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testMultiClass(x, classes, null.ok = FALSE)

test_multi_class(x, classes, null.ok = FALSE)

expect_multi_class(x, classes, null.ok = FALSE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{classes}{[\code{character}]\cr
Class names to check for inheritance with \code{\link[base]{inherits}}.
\code{x} must inherit from any of the specified classes.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertMultiClass}/\code{assert_multi_class} return 
 \code{x} invisibly, whereas
 \code{checkMultiClass}/\code{check_multi_class} and 
 \code{testMultiClass}/\code{test_multi_class} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertMultiClass}/\code{assert_multi_class}
 throws an error message, 
 \code{testMultiClass}/\code{test_multi_class}
 returns \code{FALSE},
 and \code{checkMultiClass}/\code{check_multi_class} 
 return a string with the error message.
 The function \code{expect_multi_class} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check the class membership of an argument
}
\examples{
x = 1
class(x) = "bar"
checkMultiClass(x, c("foo", "bar"))
checkMultiClass(x, c("foo", "foobar"))
}
\seealso{
Other attributes: 
\code{\link{checkClass}()},
\code{\link{checkNamed}()},
\code{\link{checkNames}()}

Other classes: 
\code{\link{checkClass}()},
\code{\link{checkR6}()}
}
\concept{attributes}
\concept{classes}
