% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_climate_data.R
\name{build_url}
\alias{build_url}
\title{Build a valid URL for downloading a file from CHCD. Follows the
format detailed here
\url{https://collaboration.cmc.ec.gc.ca/cmc/climate/Get_More_Data_Plus_de_donnees/}.}
\usage{
build_url(station_id, timecode, year, month = NA)
}
\arguments{
\item{station_id}{The ID of the station to be downloaded}

\item{timecode}{The numeric timecode to be downloaded}

\item{year}{The year of data to be loaded}

\item{month}{The month of the year to download data. Setting to NA
gets all months.}
}
\value{
A URL string
}
\description{
Build a valid URL for downloading a file from CHCD. Follows the
format detailed here
\url{https://collaboration.cmc.ec.gc.ca/cmc/climate/Get_More_Data_Plus_de_donnees/}.
}
\examples{
build_url(337,3,1980)

# The timecode can also be a string such as "m" or "month"
build_url(337,"m",1990)

# Setting the month is most useful when downloading hourly data
build_url(337,"h",1980,3)
}
