context('cpt.geo class tests')
library('changepoint.geo')
library('testthat')
library('MASS')

set.seed(1)
mu <- runif(50,-5,5)
Sigma <- runif(50,0.1,4)
MeanVarData <- rbind(mvrnorm(30,mu=mu,Sigma=diag(Sigma)),mvrnorm(30,mu=mu+0.5,Sigma=diag(Sigma*1.2)),mvrnorm(30,mu=mu-0.5,Sigma=diag(Sigma*0.9)),mvrnorm(30,mu=mu+0.5,Sigma=diag(Sigma*1.1)))

X <- geomcp(MeanVarData)
test_that(paste0('Test cpt.geo class'),{
		  expect_is(X,'cpt.geo')
		  expect_is(X@data.set,'matrix')
		  expect_is(X@distance,'numeric')
		  expect_is(X@angle,'numeric')
		  expect_is(X@penalty,'character')
		  expect_is(X@pen.value,'numeric')
		  expect_is(X@test.stat,'character')
		  expect_is(X@msl,'numeric')
		  expect_is(X@nquantiles,'integer')
		  expect_is(X@dist.cpts,'integer')
		  expect_is(X@ang.cpts,'integer')
		  expect_is(data.set(X),'matrix')
		  expect_is(distance(X),'numeric')
		  expect_is(angle(X),'numeric')
		  expect_is(penalty(X),'character')
		  expect_is(pen.value(X),'numeric')
		  expect_is(test.stat(X),'character')
		  expect_is(msl(X),'numeric')
		  expect_is(nquantiles(X),'integer')
		  expect_is(dist.cpts(X),'integer')
		  expect_is(ang.cpts(X),'integer')
		  expect_is(summary(X),'NULL')
		  expect_is(show(X),'NULL')
		  expect_is(plot(X),'ggplot')
})



