% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_cfb.R
\name{load_cfb_schedules}
\alias{load_cfb_schedules}
\title{Load CFB Game/Schedule Data from data repo}
\usage{
load_cfb_schedules(seasons = most_recent_cfb_season())
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, default \code{TRUE} returns all available data.}
}
\value{
A tibble of game information for past and/or future games.
}
\description{
This function returns game/schedule information for the specified season(s).
This function wraps the \code{cfbd_game_info()} function sourced from the College Football Data API.
}
\examples{
\donttest{
  try(load_cfb_schedules(2024))
}

}
\seealso{
\code{\link[=cfbd_game_info]{cfbd_game_info()}}

Issues with this data should be filed here: \url{https://github.com/sportsdataverse/cfbfastR-data}

Other loaders: 
\code{\link{load_cfb_pbp}()},
\code{\link{load_cfb_rosters}()},
\code{\link{load_cfb_teams}()},
\code{\link{update_cfb_db}()}
}
\concept{loaders}
