% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_cfb_pbp.R
\name{load_cfb_pbp}
\alias{load_cfb_pbp}
\title{\strong{Load cleaned play-by-play from the data repo}}
\source{
CFB Play-by-Play Data releases can be found here: \url{https://github.com/sportsdataverse/sportsdataverse-data/releases/tag/cfbfastR_cfb_pbp}
}
\usage{
load_cfb_pbp(
  seasons = most_recent_cfb_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given College Football seasons.}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{\link[=update_cfb_db]{update_cfb_db()}})}

\item{dbConnection}{A \code{DBIConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{tablename}{The name of the play by play data table within the database}
}
\value{
Returns a tibble with play-by-play data
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\seealso{
Issues with this data should be filed here: \url{https://github.com/sportsdataverse/cfbfastR-data}

\code{\link[=update_cfb_db]{update_cfb_db()}}

Other loaders: 
\code{\link{load_cfb_rosters}()},
\code{\link{load_cfb_schedules}()},
\code{\link{load_cfb_teams}()},
\code{\link{update_cfb_db}()}
}
\concept{loaders}
