% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_team_stats}
\alias{cfbd_game_team_stats}
\title{\strong{Get team statistics by game}}
\usage{
cfbd_game_team_stats(
  year,
  week = NULL,
  season_type = "regular",
  team = NULL,
  conference = NULL,
  game_id = NULL,
  division = "fbs",
  rows_per_team = 1
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY}). Required year filter (along with one of \code{week}, \code{team}, or \code{conference}), unless \code{game_id} is specified}

\item{week}{(\emph{Integer} optional): Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier. Required if \code{team} and \code{conference} not specified.}

\item{season_type}{(\emph{String} default: regular): Select Season Type - regular, postseason, both, allstar, spring_regular, spring_postseason}

\item{team}{(\emph{String} optional): D-I Team. Required if \code{week} and \code{conference} not specified.}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC
Required if \code{week} and \code{team} not specified.}

\item{game_id}{(\emph{Integer} optional): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}

\item{division}{(\emph{String} optional): Division abbreviation - Select a valid division: fbs/fcs/ii/iii}

\item{rows_per_team}{(\emph{Integer} default 1): Both Teams for each game on one or two row(s), Options: 1 or 2}
}
\value{
\code{\link[=cfbd_game_team_stats]{cfbd_game_team_stats()}} - A data frame with 78 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{home_away}: character.}{Home/Away Flag.}
\item{\code{opponent}: character.}{Opponent team name.}
\item{\code{opponent_conference}: character.}{Conference of the opponent team.}
\item{\code{points}: integer.}{Team points.}
\item{\code{total_yards}: character.}{Team total yards.}
\item{\code{net_passing_yards}: character.}{Team net passing yards.}
\item{\code{completion_attempts}:character.}{Team completion attempts.}
\item{\code{passing_tds}: character.}{Team passing touchdowns.}
\item{\code{yards_per_pass}: character.}{Team game yards per pass.}
\item{\code{passes_intercepted}: character.}{Team passes intercepted.}
\item{\code{interception_yards}: character.}{Interception yards.}
\item{\code{interception_tds}: character.}{Interceptions returned for a touchdown.}
\item{\code{rushing_attempts}: character.}{Team rushing attempts. see also: ESTABLISH IT.}
\item{\code{rushing_yards}: character.}{Team rushing yards.}
\item{\code{rush_tds}: character.}{Team rushing touchdowns.}
\item{\code{yards_per_rush_attempt}: character.}{Team yards per rush attempt.}
\item{\code{first_downs}: character.}{First downs earned by the team.}
\item{\code{third_down_eff}: character.}{Third down efficiency.}
\item{\code{fourth_down_eff}: character.}{Fourth down efficiency.}
\item{\code{punt_returns}: character.}{Team punt returns.}
\item{\code{punt_return_yards}: character.}{Team punt return yards.}
\item{\code{punt_return_tds}: character.}{Team punt return touchdowns.}
\item{\code{kick_return_yards}: character.}{Team kick return yards.}
\item{\code{kick_return_tds}: character.}{Team kick return touchdowns.}
\item{\code{kick_returns}: character.}{Team kick returns.}
\item{\code{kicking_points}: character.}{Team points from kicking the ball.}
\item{\code{fumbles_recovered}: character.}{Team fumbles recovered.}
\item{\code{fumbles_lost}: character.}{Team fumbles lost.}
\item{\code{total_fumbles}: character.}{Team total fumbles.}
\item{\code{tackles}: character.}{Team tackles.}
\item{\code{tackles_for_loss}: character.}{Team tackles for a loss.}
\item{\code{sacks}: character.}{Team sacks.}
\item{\code{qb_hurries}: character.}{Team QB hurries.}
\item{\code{interceptions}: character.}{Team interceptions.}
\item{\code{passes_deflected}: character.}{Team passes deflected.}
\item{\code{turnovers}: character.}{Team turnovers.}
\item{\code{defensive_tds}: character.}{Team defensive touchdowns.}
\item{\code{total_penalties_yards}: character.}{Team total penalty yards.}
\item{\code{possession_time}: character.}{Team time of possession.}
\item{\code{points_allowed}: integer.}{Points for the opponent.}
\item{\code{total_yards_allowed}: character.}{Opponent total yards.}
\item{\code{net_passing_yards_allowed}: character.}{Opponent net passing yards.}
\item{\code{completion_attempts_allowed}: character.}{Oppponent completion attempts.}
\item{\code{passing_tds_allowed}: character.}{Opponent passing TDs.}
\item{\code{yards_per_pass_allowed}: character.}{Opponent yards per pass allowed.}
\item{\code{passes_intercepted_allowed}: character.}{Opponent passes intercepted.}
\item{\code{interception_yards_allowed}: character.}{Opponent interception yards.}
\item{\code{interception_tds_allowed}: character.}{Opponent interception TDs.}
\item{\code{rushing_attempts_allowed}: character.}{Opponent rushing attempts.}
\item{\code{rushing_yards_allowed}: character.}{Opponent rushing yards.}
\item{\code{rush_tds_allowed}: character.}{Opponent rushing touchdowns.}
\item{\code{yards_per_rush_attempt_allowed}: character.}{Opponent rushing yards per attempt.}
\item{\code{first_downs_allowed}: character.}{Opponent first downs.}
\item{\code{third_down_eff_allowed}: character.}{Opponent third down efficiency.}
\item{\code{fourth_down_eff_allowed}: character.}{Opponent fourth down efficiency.}
\item{\code{punt_returns_allowed}: character.}{Opponent punt returns.}
\item{\code{punt_return_yards_allowed}: character.}{Opponent punt return yards.}
\item{\code{punt_return_tds_allowed}: character.}{Opponent punt return touchdowns.}
\item{\code{kick_return_yards_allowed}: character.}{Opponent kick return yards.}
\item{\code{kick_return_tds_allowed}: character.}{Opponent kick return touchdowns.}
\item{\code{kick_returns_allowed}: character.}{Opponent kick returns.}
\item{\code{kicking_points_allowed}: character.}{Opponent points from kicking.}
\item{\code{fumbles_recovered_allowed}: character.}{Opponent fumbles recovered.}
\item{\code{fumbles_lost_allowed}: character.}{Opponent fumbles lost.}
\item{\code{total_fumbles_allowed}:character.}{Opponent total number of fumbles.}
\item{\code{tackles_allowed}:character.}{Opponent tackles.}
\item{\code{tackles_for_loss_allowed}: character.}{Opponent tackles for loss.}
\item{\code{sacks_allowed}: character.}{Opponent sacks.}
\item{\code{qb_hurries_allowed}: character.}{Opponent quarterback hurries.}
\item{\code{interceptions_allowed}: character.}{Opponent interceptions.}
\item{\code{passes_deflected_allowed}: character.}{Opponent passes deflected.}
\item{\code{turnovers_allowed}: character.}{Opponent turnovers.}
\item{\code{defensive_tds_allowed}: character.}{Opponent defensive touchdowns.}
\item{\code{total_penalties_yards_allowed}: character.}{Opponent total penalty yards.}
\item{\code{possession_time_allowed}: character.}{Opponent time of possession.}
}
}
\description{
\strong{Get team statistics by game}
}
\examples{
\donttest{
  try(cfbd_game_team_stats(2022, team = "LSU"))

  try(cfbd_game_team_stats(2013, team = "Florida State"))
}
}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_calendar}()},
\code{\link{cfbd_game_box_advanced}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_player_stats}()},
\code{\link{cfbd_game_records}()},
\code{\link{cfbd_game_weather}()},
\code{\link{cfbd_live_scoreboard}()}
}
\concept{CFBD Games}
\keyword{Game}
\keyword{Stats}
\keyword{Team}
