% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_plot.R
\name{stack_plot}
\alias{stack_plot}
\alias{stack_ggplot}
\title{Stacked bar plot}
\usage{
stack_plot(
  x,
  percent = FALSE,
  order_col = 1,
  scheme = NULL,
  order_cells = c("none", "increase", "decrease"),
  seriate = NULL,
  cex.names = 0.7,
  show_xticks = TRUE,
  ...
)

stack_ggplot(
  x,
  percent = FALSE,
  order_col = 1,
  scheme = NULL,
  order_cells = c("none", "increase", "decrease"),
  seriate = NULL,
  legend_ncol = NULL,
  legend_position = "bottom",
  show_xticks = FALSE
)
}
\arguments{
\item{x}{matrix of deconvolution results with samples in rows and cell
subclasses or groups in columns. If a 'deconv' class object is supplied the
deconvolution values for the cell subclasses are extracted and plotted.}

\item{percent}{Logical whether to scale the matrix rows as percentage.}

\item{order_col}{Numeric value for which column (cell subclass) to use to
sort the bars - this only applies if \code{percent = TRUE}. If a vector of
column indices is supplied, these columns are averaged first using
\code{rowMeans()}. If \code{percent = FALSE}, then the default is to sort bars from
low to high based on the row sums (i.e. total subclass cell amounts in each
sample). Setting \code{order_col = 0} disables sorting of bars; in this case
bars are shown in the original order of the rows of \code{x}.}

\item{scheme}{Vector of colours. If not supplied, the default scheme uses
\code{scales::hue_pal()}.}

\item{order_cells}{Character value specifying with cell types are ordered by
abundance.}

\item{seriate}{Character value which enables ordering of samples using the
\code{seriation} package. Any matrix based seriation methods can be used to
order the samples. Recommended options include "CA", "BEA" or "BEA_TSP".}

\item{cex.names}{Character expansion controlling bar names font size.}

\item{show_xticks}{Logical whether to show rownames as x axis labels.}

\item{...}{Optional arguments passed to \code{\link[graphics:barplot]{graphics::barplot()}}.}

\item{legend_ncol}{Number of columns for ggplot2 legend. If set to \code{NULL}
ggplot2 sets the column number automatically.}

\item{legend_position}{Position of ggplot2 legend}
}
\value{
The base graphics function has no return value. It plots a stacked
barchart using base graphics. The ggplot2 version returns a ggplot2 object.
}
\description{
Produces stacked bar plots using base graphics or ggplot2 showing amounts of
cell subclasses in deconvoluted bulk samples.
}
