% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_map.R
\name{quantile_map}
\alias{quantile_map}
\title{Quantile mapping function between two scRNA-Seq datasets}
\usage{
quantile_map(
  x,
  y,
  n = 10000,
  remove_noncoding = TRUE,
  remove_zeros = FALSE,
  smooth = "loess",
  span = 0.15,
  knots = c(0.25, 0.75, 0.85, 0.95, 0.97, 0.99, 0.999),
  respace = FALSE,
  silent = FALSE
)
}
\arguments{
\item{x}{scRNA-Seq data whose distribution is to be mapped onto \code{y}: either a
matrix of gene expression on log2+1 scale, or a 'cellMarkers' class object,
in which case the \verb{$genemeans} list element is extracted.}

\item{y}{Reference scRNA-Seq data: either a matrix of gene expression on
log2+1 scale, or a 'cellMarkers' class object, in which case the
\verb{$genemeans} list element is extracted.}

\item{n}{Number of quantiles to split \code{x} and \code{y}.}

\item{remove_noncoding}{Logical, whether to remove noncoding. This is a basic
filter which looks at the gene names (rownames) in both matrices and
removes genes containing "-" which are usually antisense or mitochondrial
genes, or "." which are either pseudogenes or ribosomal genes.}

\item{remove_zeros}{Logical, whether to remove zeros from both datasets.
This shifts the quantile relationships.}

\item{smooth}{Either "loess" or "lowess" which apply \code{\link[=loess]{loess()}} or \code{\link[=lowess]{lowess()}}
to smooth the QQ fitted line, or "ns" which uses natural splines via
\code{\link[=ns]{ns()}}. With any other value no smoothing is applied. With no smoothing or
"loess/lowess", interpolation is limited to the original range of \code{x}, i.e.
it will clip for values > \code{max(x)}.}

\item{span}{controls the degree of smoothing in \code{\link[=loess]{loess()}} and \code{\link[=lowess]{lowess()}}.}

\item{knots}{Vector of quantile points for knots for fitting natural splines.}

\item{respace}{Logical whether to respace quantile points so their x axis
density is more even. Can help spline fitting.}

\item{silent}{Logical whether to suppress messages.}
}
\value{
A list object of class 'qqmap' containing:
\item{quantiles}{Dataframe containing matching quantiles of \code{x} and \code{y}}
\item{map}{A function of form \code{FUN(x)} where \code{x} can be supplied as a numeric
vector or matrix and the same type is returned. The function converts given
data points to the distribution of \code{y}.}
}
\description{
Quantile mapping to combine two scRNA-Seq datasets based on mapping either
the distribution of mean log2+1 gene expression in cell clusters to the
distribution of the 2nd dataset, or mapping the quantiles of one matrix of
gene expression (with genes in rows) to another.
}
\details{
The conversion uses the function \code{\link[=approxfun]{approxfun()}} which uses interpolation. It
is not designed to perform stepwise (exact) quantile transformation of every
individual datapoint.
}
\seealso{
\code{\link[=approxfun]{approxfun()}}
}
