#' Synthetic Data for Illustration
#'
#' A randomly generated dataset containing 1000 rows and 9 columns with no
#' missing values.
#'
#' @usage sdata
#'
#' @format A data frame containing the following variables. The data are
#'   provided only for explanatory purposes. The mediators are assumed to be
#'   independent of each other.
#' \describe{
#'   \item{C.num:}{ A quantitative covariate.}
#'   \item{C.bin:}{ A binary covariates with a value of 0 or 1.}
#'   \item{R:}{ A group indicator with four levels.}
#'   \item{X:}{ A quantitative intermediate confounder between a mediator and the outcome.}
#'   \item{M.num:}{ A quantitative mediator.}
#'   \item{M.bin:}{ A binary mediator with a value of 0 or 1.}
#'   \item{M.cat:}{ A categorical mediator with three levels.}
#'   \item{Y.num:}{ A quantitative outcome.}
#'   \item{Y.bin:}{ A binary outcome with a value of 0 or 1.}
#' }
#'
#' @details Note that all the variables are randomly generated using the dataset
#'   used in Park et al. (2024).
#'
#' @references Park, S., Kang, S., and Lee, C. (2024). "Choosing an optimal method for causal
#'   decomposition analysis with continuous outcomes: A review and simulation study",
#'   Sociological methodology, 54(1), 92-117.
#'
#' @keywords datasets
"sdata"


#' Synthetic Data Generated Based on the Midlife Development in the U.S. (MIDUS) Study
#'
#' This is a synthetic dataset that includes variables from the Midlife Development
#' in the U.S. (MIDUS) study. It has been artificially generated based on the actual
#' MIDUS data, which is not publicly available due to confidentiality concerns.
#' The synthetic data set consists of 1948 rows and 9 columns, with no missing values.
#'
#' @usage sMIDUS
#'
#' @format A data frame containing the following variables.
#' \describe{
#'   \item{health:}{ cardiovascular health score.}
#'   \item{racesex:}{ race-gender groups with four levels (1: White men, 2: White women, 3: Black men, 4: Black women).}
#'   \item{lowchildSES:}{ socioeconomic status (SES) in the childhood.}
#'   \item{abuse:}{ adverse experience in the childhood.}
#'   \item{edu:}{ education level.}
#'   \item{age:}{ age.}
#'   \item{stroke:}{ genetic vulnerability with a value of 0 or 1.}
#'   \item{T2DM:}{ genetic vulnerability with a value of 0 or 1.}
#'   \item{heart:}{ genetic vulnerability with a value of 0 or 1.}
#' }
#'
#' @details Note that all the variables are fabricated using the actual MIDUS data
#'   used in Park et al. (2023).
#'
#' @references Park, S., Kang, S., Lee, C., & Ma, S. (2023). Sensitivity analysis for causal
#'   decomposition analysis: Assessing robustness toward omitted variable bias,
#'   Journal of Causal Inference, 11(1), 20220031.
#'
#' @keywords datasets
"sMIDUS"


#' Synthetic Data for illustrating optimal treatment regimes and individualized effects
#'
#' A randomly generated dataset containing 2000 cases 7 columns with no missing values.
#' The intermediate confounders are assumed to be independent of each other.
#'
#' @usage idata
#'
#' @format A data frame containing the following variables. The data are provided only for
#'   explanatory purposes.
#' \describe{
#'   \item{Y:}{ A continuous outcome variable.}
#'   \item{R:}{ A binary group indicator with a value of 0 (reference) and 1 (comparison).}
#'   \item{M:}{ A binary risk factor with a value of 0 (not treated/received) and 1(treated/received).}
#'   \item{X1:}{ First continuous intermediate confounder.}
#'   \item{X2:}{ Second continuous intermediate confounder.}
#'   \item{X3:}{ Third continuous intermediate confounder.}
#'   \item{C:}{ A continuous baseline covariate.}
#' }
#'
#' @details Note that all the variables are randomly generated using the simulation setting
#'   in Park, S., Kang, S., & Lee, C. (2025).
#'
#' @references
#'   Park, S., Kang, S., & Lee, C. (2025). Simulation-Based Sensitivity Analysis in
#'   Optimal Treatment Regimes and Causal Decomposition with Individualized Interventions.
#'   arXiv preprint arXiv:2506.19010.
#'
#' @keywords datasets
"idata"
