% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{predictors}
\alias{predictors}
\alias{predictors.sdm_area}
\alias{predictors.input_sdm}
\alias{set_predictor_names}
\alias{set_predictor_names.input_sdm}
\alias{set_predictor_names.sdm_area}
\alias{get_predictor_names}
\alias{get_predictor_names.sdm_area}
\alias{get_predictor_names.input_sdm}
\alias{test_variables_names}
\alias{set_variables_names}
\title{Predictors Names Managing}
\usage{
predictors(x)

\method{predictors}{sdm_area}(x)

\method{predictors}{input_sdm}(x)

set_predictor_names(x, new_names)

\method{set_predictor_names}{input_sdm}(x, new_names)

\method{set_predictor_names}{sdm_area}(x, new_names)

get_predictor_names(x)

\method{get_predictor_names}{sdm_area}(x)

\method{get_predictor_names}{input_sdm}(x)

test_variables_names(sa, scen)

set_variables_names(s1 = NULL, s2 = NULL, new_names = NULL)
}
\arguments{
\item{x}{A \code{sdm_area} or \code{input_sdm} object to get/set predictors names.}

\item{new_names}{A \code{character} vector from size \code{length(get_predictor_names(x))}}

\item{sa}{A \code{sdm_area} object.}

\item{scen}{A \code{stars} object with scenarios.}

\item{s1}{A \code{stars} object with scenarios.}

\item{s2}{A \code{stars} object with scenarios or a \code{sdm_area} object.}
}
\value{
\code{predictors} and \code{get_predictor_names} return a \code{character} vector with
predictors names.
\code{test_variables_names} returns a logical informing if all variables are equal in both
objects (TRUE) or not (FALSE).
\code{set_variables_names} returns the \code{s1} object with new names provided by \code{s2} or
\code{new_names}.
}
\description{
This function manage predictors names in \code{sdm_area} objects.
}
\details{
This functions is available so users can modify predictors names to better represent them. Use
carefully to avoid giving wrong names to the predictors. Useful to make sure the predictors names
are equal the names in scenarios.
\code{test_variables_names} Tests if variables in a \code{stars} object (\code{scen} argument)
matches the given \code{sdm_area} object (\code{sa} argument).
\code{set_variables_names} will set \code{s1} object variables names as the \code{s2} object
variables names OR assign new names to it.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 50000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc)

# Check predictors' names:
get_predictor_names(sa)

}
\seealso{
\code{\link{parana} \link{sdm_area}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
