% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_twogrid_overlap}
\alias{make_twogrid_overlap}
\title{Generate Two Overlapping Grid Clusters in High Dimensions}
\usage{
make_twogrid_overlap(n = c(500, 500), p = 4)
}
\arguments{
\item{n}{A numeric vector of length 2 specifying the number of points
in each grid cluster.}

\item{p}{An integer specifying the total number of dimensions.
Must be greater than or equal to 2. If \code{p > 2}, additional
noise dimensions are appended.}
}
\value{
A tibble with \code{n[1] + n[2]} rows and \code{p + 1} columns:
  \itemize{
    \item \code{x1, ..., xp} — coordinates of the generated points.
    \item \code{cluster} — cluster membership label.
  }
}
\description{
This function generates a dataset consisting of two overlapping
grid-like clusters in a 2D space, with optional noise dimensions
added to reach higher-dimensional spaces. The overlap is controlled
by scaling factors for the grids.
}
\examples{
# Generate two overlapping grid clusters in 4-D
df <- make_twogrid_overlap()

}
