% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{CADBCD_Sim_Surv}
\alias{CADBCD_Sim_Surv}
\title{Simulation For Covariate Adjusted Doubly Biased Coin Design for Survival Response}
\usage{
CADBCD_Sim_Surv(
  n,
  thetaA,
  thetaB,
  m0 = 40,
  pts.cov,
  v = 2,
  target,
  censor.time,
  arrival.rate
)
}
\arguments{
\item{n}{a positive integer. The value specifies the total number of participants involved in each round of the simulation.}

\item{thetaA}{a vector of length \code{k}. The true coefficient parameter value for treatment A.}

\item{thetaB}{a vector of length \code{k}. The true coefficient parameter value for treatment B.}

\item{m0}{a positive integer. The number of first 2m0 patients will be allocated equally for estimation. The default value is 40.}

\item{pts.cov}{a \code{n x k} matrix. The simulated covariate matrix for patients.}

\item{v}{a non-negative integer that controls the randomness of CADBCD design. The default value is 2.}

\item{target}{the type of optimal allocation target. Options are \code{"Neyman"} or \code{"RSIHR"}.}

\item{censor.time}{a positive value. The upper bound to the simulated uniform censor time.}

\item{arrival.rate}{a positive value. The rate of simulated exponential arrival time.}
}
\value{
A list with the following elements:
\item{method}{The name of procedure.}
\item{sampleSize}{Sample size of the trial.}
\item{parameter}{Estimated parameters used to do the simulations.}
\item{N.events}{Total number of events of the trial.}
\item{assignment}{The randomization sequence.}
\item{proportion}{Average allocation proportion for treatment A.}
\item{responses}{The simulated observed survival responses of patients.}
\item{events}{Whether events are observed for patients(1=event,0=censored).}
\item{rejectNull}{Whether the study to detect a significant difference of treatment effect using Wald test.}
}
\description{
This function simulates a clinical trial with time-to-event (survival) outcomes using
the Covariate Adjusted Doubly Biased Coin Design (CADBCD).
Patient responses are generated under the Cox proportional hazards model,
assuming the proportional hazards assumption holds.
}
\examples{
set.seed(123)

## Run CADBCD simulation with survival response
results = CADBCD_Sim_Surv(
  thetaA = c(0.1, 0.1),
  thetaB = c(-1, 0.1),
  n = 400,
  pts.cov = cbind(sample(c(1, 0), 400, replace = TRUE), rnorm(400)),
  target = "RSIHR",
  censor.time = 2,
  arrival.rate = 150
)
}
\concept{CADBCD Design}
