% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciesAccum.R
\name{speciesAccum}
\alias{speciesAccum}
\title{Species Accumulation Curves for Camera Trap Data}
\usage{
speciesAccum(
  CTtable,
  recordTable,
  speciesCol,
  recordDateTimeCol,
  recordDateTimeFormat = "ymd HMS",
  setupCol,
  dateFormat = "ymd",
  stationCol,
  assemblageCol = NULL,
  q = 0,
  x_unit = c("station", "survey_day", "station_day"),
  knots = 40,
  conf = 0.95,
  nboot = 50,
  endpoint = NULL
)
}
\arguments{
\item{CTtable}{data.frame containing the camera trap deployment information.}

\item{recordTable}{data.frame containing the camera trap records.}

\item{speciesCol}{character. Name of the column specifying species names in recordTable}

\item{recordDateTimeCol}{character. Name of the column containing date and time information in recordTable}

\item{recordDateTimeFormat}{character. Format of column \code{recordDateTimeCol} in \code{recordTable}}

\item{setupCol}{character. Name of the column containing camera setup dates in CTtable}

\item{dateFormat}{character. Format of column \code{setupCol} in \code{CTtable}}

\item{stationCol}{character. Name of the column containing station IDs in both tables}

\item{assemblageCol}{character. Optional. Name of column in recordTable for grouping data into separate assemblages}

\item{q}{numeric. The order of diversity measure. Default is 0 (species richness)}

\item{x_unit}{character. Whether to use "station" or "day" as sampling unit. Default is "station"}

\item{knots}{numeric. number of values along x axis for which values are computed}

\item{conf}{numeric. confidence interval}

\item{nboot}{numeric. number of replications}

\item{endpoint}{integer. Sample size used as endpoint for rarefaction/extrapolation (in \code{\link[iNEXT]{iNEXT}})}
}
\value{
An object of class "iNEXT" containing:
\itemize{
  \item DataInfo - data information
  \item iNextEst - diversity estimates for rarefied and extrapolated samples
  \item AsyEst - asymptotic diversity estimates
}
}
\description{
Generates species accumulation, rarefaction and extrapolation curves
   from camera trap data using the \pkg{iNEXT} package (Chao et al. 2014). The function
   creates sampling effort-based accumulation curves with sampling units being either
   camera trap stations or days.
   
   Note that these curves are based on observed detections only and do not account 
   for imperfect detection. Species may be present but not detected, leading to 
   underestimation of true species richness. For analyses that explicitly account 
   for imperfect detection, consider using occupancy-based approaches (see 
   \code{\link{communityModel}}).
}
\details{
The function provides three types of curves:
\itemize{
  \item Sample-size-based rarefaction/extrapolation curve
  \item Sample completeness curve
  \item Coverage-based rarefaction/extrapolation curve
}

While these curves provide useful insights into sampling completeness and species 
richness patterns, they should be interpreted with caution in camera trap studies. 
Unlike occupancy models, they do not account for:
\itemize{
  \item Imperfect detection (species present but not detected)
  \item Variation in detection probability among species
  \item Spatial variation in species occurrence
  \item Temporal variation in species activity
}
}
\note{
Requires package \pkg{iNEXT}.
}
\examples{
\dontrun{
# Basic usage with stations as sampling units
result <- speciesAccum(
  CTtable = cams,
  recordTable = recs,
  speciesCol = "Species",
  recordDateTimeCol = "DateTime", 
  setupCol = "Setup_date",
  stationCol = "Station",
  q = 0,
  x_unit = "station"
)

# Plot results
ggiNEXT(result, type = 1)  # Sample-size-based R/E curve
ggiNEXT(result, type = 2)  # Sample completeness curve
ggiNEXT(result, type = 3)  # Coverage-based R/E curve

# With assemblage grouping and days as sampling units
result_by_assemblage <- speciesAccum(
  CTtable = cams,
  recordTable = recs,
  speciesCol = "Species",
  recordDateTimeCol = "DateTime",
  setupCol = "Setup_date",
  stationCol = "Station",
  assemblageCol = "Season",
  q = 0,
  x_unit = "day"
)
}

}
\references{
Chao, A., Gotelli, N. J., Hsieh, T. C., Sander, E. L., Ma, K. H., Colwell, R. K., 
& Ellison, A. M. (2014). Rarefaction and extrapolation with Hill numbers: 
A framework for sampling and estimation in species diversity studies. 
Ecological Monographs, 84(1), 45-67.
}
\seealso{
\code{\link{surveyDashboard}} for interactive species accumulation analysis
}
\author{
Juergen Niedballa
}
