% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWildlifeInsights.R
\name{readWildlifeInsights}
\alias{readWildlifeInsights}
\title{Import Wildlife Insights data to camtrapR}
\usage{
readWildlifeInsights(
  directory = NULL,
  zipfile = NULL,
  deployment_file = NULL,
  image_file = NULL
)
}
\arguments{
\item{directory}{character. Path to folder containing CSV files exported from Wildlife Insights.}

\item{zipfile}{character. Path to a ZIP file exported from Wildlife Insights.}

\item{deployment_file}{character. Path to the deployments CSV file.}

\item{image_file}{character. Path to the images CSV file.}
}
\value{
A list containing three elements:
\describe{
  \item{CTtable}{The full camera trap table, based on deployments.csv}
  \item{CTtable_aggregated}{An aggregated version of the camera trap table, with one row per station}
  \item{recordTable}{The record table, based on images.csv with additional columns from deployments.csv}
}
}
\description{
This function imports camera trap data from Wildlife Insights into a format compatible with camtrapR.
It can read data from a directory containing CSV files, from a ZIP file, or from individual CSV files.
}
\examples{
\dontrun{
# Reading from a directory
wi_data <- readWildlifeInsights(directory = "path/to/csv/files")

# Reading from a ZIP file
wi_data <- readWildlifeInsights(zipfile = "path/to/wildlife_insights_export.zip")

# Reading from separate CSV files
wi_data <- readWildlifeInsights(deployment_file = "path/to/deployments.csv",
                                image_file = "path/to/images.csv")
}
}
