% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile.bspcov.R
\name{quantile.bspcov}
\alias{quantile.bspcov}
\title{Quantiles of posterior distribution}
\usage{
\method{quantile}{bspcov}(x, probs = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{x}{an object from \strong{bandPPP}, \strong{bmspcov}, \strong{sbmspcov}, and \strong{thresPPP}.}

\item{probs}{numeric vector of probabilities with values in [0,1]. Default is c(0.025, 0.5, 0.975).}

\item{...}{additional arguments for quantile.}
}
\value{
\item{quantiles}{a list containing quantile matrices for each probability level. For multiple chains, uses combined samples from all chains.}
}
\description{
Compute quantiles to describe posterior distribution.
For multiple chains, combines all chains to compute more robust quantiles.
}
\examples{
\donttest{
# Example with simulated data
n <- 25
p <- 50
Sigma0 <- diag(1, p)
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma0)
res <- bspcov::bandPPP(X, 2, 0.01, nsample=100)
quant <- quantile(res)

# Get 95\% credible intervals
quant <- quantile(res, probs = c(0.025, 0.975))
}

}
\seealso{
estimate, plot.postmean.bspcov
}
\author{
Kyeongwon Lee
}
