% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.quantile.bspcov.R
\name{plot.quantile.bspcov}
\alias{plot.quantile.bspcov}
\title{Plot method for quantile.bspcov objects}
\usage{
\method{plot}{quantile.bspcov}(
  x,
  type = "heatmap",
  titles = NULL,
  ncol = 3,
  color_limits = NULL,
  color_low = "black",
  color_high = "white",
  base_size = 14,
  legend_position = "bottom",
  x_label = "Variable",
  y_label = "Variable",
  width = NULL,
  height = 6,
  ...
)
}
\arguments{
\item{x}{an object of class \code{quantile.bspcov} from \code{quantile()} function.}

\item{type}{character string specifying plot type. Options are "heatmap" (default), "uncertainty", or "comparison".}

\item{titles}{character vector of titles for each quantile plot. If NULL, auto-generated titles are used.}

\item{ncol}{number of columns in the plot layout. Default is 3.}

\item{color_limits}{optional vector of length 2 specifying color scale limits. If NULL, computed from data.}

\item{color_low}{color for low values in heatmap. Default is "black".}

\item{color_high}{color for high values in heatmap. Default is "white".}

\item{base_size}{base font size for plot theme. Default is 14.}

\item{legend_position}{position of legend. Default is "bottom".}

\item{x_label}{label for x-axis. Default is "Variable".}

\item{y_label}{label for y-axis. Default is "Variable".}

\item{width}{plot width when saving. Default is calculated based on number of quantiles.}

\item{height}{plot height when saving. Default is 6.}

\item{...}{additional arguments passed to plotting functions.}
}
\value{
A ggplot object (single quantile) or patchwork object (multiple quantiles) showing heatmap visualizations.
}
\description{
Create visualization plots for posterior quantiles of covariance matrices.
Produces heatmap visualizations showing uncertainty across different quantile levels.
}
\examples{
\donttest{
# Example with simulated data
n <- 25
p <- 50
Sigma0 <- diag(1, p)
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma0)
res <- bspcov::bandPPP(X, 2, 0.01, nsample = 100)
quant <- quantile(res)

# Plot uncertainty visualization
plot(quant)

# Plot with custom titles and labels
plot(quant, titles = c("Lower Bound", "Median", "Upper Bound"),
     x_label = "Variable", y_label = "Variable")
}

}
\seealso{
quantile, plot.bspcov, plot.postmean.bspcov
}
\author{
Kyeongwon Lee
}
