% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam.R
\name{tidy.Gam}
\alias{tidy.Gam}
\alias{Gam_tidiers}
\title{Tidy a(n) Gam object}
\usage{
\method{tidy}{Gam}(x, ...)
}
\arguments{
\item{x}{A \code{Gam} object returned from a call to \code{\link[gam:gam]{gam::gam()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Tidy \code{gam} objects created by calls to \code{\link[mgcv:gam]{mgcv::gam()}} with
\code{\link[=tidy.gam]{tidy.gam()}}.
}
\examples{
\dontshow{if (rlang::is_installed("gam")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(gam)

# fit model
g <- gam(mpg ~ s(hp, 4) + am + qsec, data = mtcars)

# summarize model fit with tidiers
tidy(g)
glance(g)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[gam:gam]{gam::gam()}}, \code{\link[=tidy.anova]{tidy.anova()}}, \code{\link[=tidy.gam]{tidy.gam()}}

Other gam tidiers: 
\code{\link{glance.Gam}()}
}
\concept{gam tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{df}{Degrees of freedom used by this term in the model.}
  \item{meansq}{Mean sum of squares. Equal to total sum of squares divided by degrees of freedom.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{sumsq}{Sum of squares explained by this term.}
  \item{term}{The name of the regression term.}

}
