% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo.R
\name{tidy.zoo}
\alias{tidy.zoo}
\alias{zoo_tidiers}
\title{Tidy a(n) zoo object}
\usage{
\method{tidy}{zoo}(x, ...)
}
\arguments{
\item{x}{A \code{zoo} object such as those created by \code{\link[zoo:zoo]{zoo::zoo()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed(c("zoo", "ggplot2"))) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(zoo)
library(ggplot2)

set.seed(1071)

# generate data
Z.index <- as.Date(sample(12450:12500, 10))
Z.data <- matrix(rnorm(30), ncol = 3)
colnames(Z.data) <- c("Aa", "Bb", "Cc")
Z <- zoo(Z.data, Z.index)

# summarize model fit with tidiers + visualization
tidy(Z)

ggplot(tidy(Z), aes(index, value, color = series)) +
  geom_line()

ggplot(tidy(Z), aes(index, value)) +
  geom_line() +
  facet_wrap(~series, ncol = 1)

Zrolled <- rollmean(Z, 5)
ggplot(tidy(Zrolled), aes(index, value, color = series)) +
  geom_line()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[zoo:zoo]{zoo::zoo()}}

Other time series tidiers: 
\code{\link{tidy.acf}()},
\code{\link{tidy.spec}()},
\code{\link{tidy.ts}()}
}
\concept{time series tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{index}{Index (i.e. date or time) for a `ts` or `zoo` object.}
  \item{series}{Name of the series (present only for multivariate time series).}
  \item{value}{The value/estimate of the component. Results from data reshaping.}

}
