% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-kmeans.R
\name{tidy.kmeans}
\alias{tidy.kmeans}
\alias{kmeans_tidiers}
\title{Tidy a(n) kmeans object}
\usage{
\method{tidy}{kmeans}(x, col.names = colnames(x$centers), ...)
}
\arguments{
\item{x}{A \code{kmeans} object created by \code{\link[stats:kmeans]{stats::kmeans()}}.}

\item{col.names}{Dimension names. Defaults to the names of the variables
in x.  Set to NULL to get names \verb{x1, x2, ...}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}

library(cluster)
library(modeldata)
library(dplyr)

data(hpc_data)

x <- hpc_data[, 2:5]

fit <- pam(x, k = 4)

tidy(fit)
glance(fit)
augment(fit, x)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:kmeans]{stats::kmeans()}}

Other kmeans tidiers: 
\code{\link{augment.kmeans}()},
\code{\link{glance.kmeans}()}
}
\concept{kmeans tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{cluster}{A factor describing the cluster from 1:k.}
  \item{size}{Number of points assigned to cluster.}
  \item{withinss}{The within-cluster sum of squares.}

}
