% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpred.R
\name{get_refmodel.brmsfit}
\alias{get_refmodel.brmsfit}
\title{Projection Predictive Variable Selection: Get Reference Model}
\usage{
get_refmodel.brmsfit(
  object,
  newdata = NULL,
  resp = NULL,
  cvfun = NULL,
  dis = NULL,
  latent = FALSE,
  brms_seed = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used. \code{NA}
values within factors (excluding grouping variables) are interpreted as if
all dummy variables of this factor are zero. This allows, for instance, to
make predictions of the grand mean when using sum coding. \code{NA} values
within grouping variables are treated as a new level.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{cvfun}{Optional cross-validation function
(see \code{\link[projpred:get_refmodel]{get_refmodel}} for details).
If \code{NULL} (the default), \code{cvfun} is defined internally
based on \code{\link{kfold.brmsfit}}.}

\item{dis}{Passed to argument \code{dis} of
\code{\link[projpred:init_refmodel]{init_refmodel}}, but leave this at
\code{NULL} unless \pkg{projpred} complains about it.}

\item{latent}{See argument \code{latent} of
\code{\link[projpred:extend_family]{extend_family}}. Setting this to
\code{TRUE} requires a \pkg{projpred} version >= 2.4.0.}

\item{brms_seed}{A seed used to infer seeds for \code{\link{kfold.brmsfit}}
and for sampling group-level effects for new levels (in multilevel models).
If \code{NULL}, then \code{\link{set.seed}} is not called at all. If not
\code{NULL}, then the pseudorandom number generator (PRNG) state is reset
(to the state before calling this function) upon exiting this function.}

\item{...}{Further arguments passed to
\code{\link[projpred:init_refmodel]{init_refmodel}}.}
}
\value{
A \code{refmodel} object to be used in conjunction with the
  \pkg{projpred} package.
}
\description{
The \code{get_refmodel.brmsfit} method can be used to create the reference
model structure which is needed by the \pkg{projpred} package for performing
a projection predictive variable selection. This method is called
automatically when performing variable selection via
\code{\link[projpred:varsel]{varsel}} or
\code{\link[projpred:cv_varsel]{cv_varsel}}, so you will rarely need to call
it manually yourself.
}
\details{
The \code{extract_model_data} function used internally by
  \code{get_refmodel.brmsfit} ignores arguments \code{wrhs} and \code{orhs}
  (a warning is thrown if these are non-\code{NULL}). For example, arguments
  \code{weightsnew} and \code{offsetnew} of
  \code{\link[projpred:proj_linpred]{proj_linpred}},
  \code{\link[projpred:proj_predict]{proj_predict}}, and
  \code{\link[projpred:predict.refmodel]{predict.refmodel}} are passed to
  \code{wrhs} and \code{orhs}, respectively.
}
\examples{
\dontrun{
# fit a simple model
fit <- brm(count ~ zAge + zBase * Trt,
           data = epilepsy, family = poisson())
summary(fit)

# The following code requires the 'projpred' package to be installed:
library(projpred)

# perform variable selection without cross-validation
vs <- varsel(fit)
summary(vs)
plot(vs)

# perform variable selection with cross-validation
cv_vs <- cv_varsel(fit)
summary(cv_vs)
plot(cv_vs)
}
}
