% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{db_workspace_mkdirs}
\alias{db_workspace_mkdirs}
\title{Make a Directory (Workspaces)}
\usage{
db_workspace_mkdirs(
  path,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{Absolute path of the directory.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Make a Directory (Workspaces)
}
\details{
Create the given directory and necessary parent directories if they do not
exists. If there exists an object (not a directory) at any prefix of the
input path, this call returns an error \code{RESOURCE_ALREADY_EXISTS.} If this
operation fails it may have succeeded in creating some of the necessary
parent directories.
}
\seealso{
Other Workspace API: 
\code{\link{db_workspace_delete}()},
\code{\link{db_workspace_export}()},
\code{\link{db_workspace_get_status}()},
\code{\link{db_workspace_import}()},
\code{\link{db_workspace_list}()}
}
\concept{Workspace API}
