% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-catalogs.R
\name{db_uc_catalogs_list}
\alias{db_uc_catalogs_list}
\title{List Catalogs (Unity Catalog)}
\usage{
db_uc_catalogs_list(
  max_results = 1000,
  include_browse = TRUE,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{max_results}{Maximum number of catalogs to return (default: 1000).}

\item{include_browse}{Whether to include catalogs in the response for which
the principal can only access selective metadata for.}

\item{page_token}{Opaque token used to get the next page of results. Optional.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
List Catalogs (Unity Catalog)
}
\seealso{
Other Unity Catalog Management: 
\code{\link{db_uc_catalogs_get}()},
\code{\link{db_uc_schemas_get}()},
\code{\link{db_uc_schemas_list}()}
}
\concept{Unity Catalog Management}
