% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{db_cluster_start}
\alias{db_cluster_start}
\title{Start a Cluster}
\usage{
db_cluster_start(
  cluster_id,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{Canonical identifier for the cluster.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Start a Cluster
}
\details{
Start a terminated cluster given its ID.

This is similar to \code{\link[=db_cluster_create]{db_cluster_create()}}, except:
\itemize{
\item The terminated cluster ID and attributes are preserved.
\item The cluster starts with the last specified cluster size. If the terminated
cluster is an autoscaling cluster, the cluster starts with the minimum number
of nodes.
\item If the cluster is in the \code{RESTARTING} state, a \code{400} error is returned.
\item You cannot start a cluster launched to run a job.
}
}
\seealso{
Other Clusters API: 
\code{\link{db_cluster_create}()},
\code{\link{db_cluster_edit}()},
\code{\link{db_cluster_events}()},
\code{\link{db_cluster_get}()},
\code{\link{db_cluster_list}()},
\code{\link{db_cluster_list_node_types}()},
\code{\link{db_cluster_list_zones}()},
\code{\link{db_cluster_perm_delete}()},
\code{\link{db_cluster_pin}()},
\code{\link{db_cluster_resize}()},
\code{\link{db_cluster_restart}()},
\code{\link{db_cluster_runtime_versions}()},
\code{\link{db_cluster_terminate}()},
\code{\link{db_cluster_unpin}()},
\code{\link{get_and_start_cluster}()},
\code{\link{get_latest_dbr}()}
}
\concept{Clusters API}
