% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{db_cluster_edit}
\alias{db_cluster_edit}
\title{Edit a Cluster}
\usage{
db_cluster_edit(
  cluster_id,
  spark_version,
  node_type_id,
  num_workers = NULL,
  autoscale = NULL,
  name = NULL,
  spark_conf = NULL,
  cloud_attrs = NULL,
  driver_node_type_id = NULL,
  custom_tags = NULL,
  init_scripts = NULL,
  spark_env_vars = NULL,
  autotermination_minutes = NULL,
  log_conf = NULL,
  ssh_public_keys = NULL,
  driver_instance_pool_id = NULL,
  instance_pool_id = NULL,
  idempotency_token = NULL,
  enable_elastic_disk = NULL,
  apply_policy_default_values = NULL,
  enable_local_disk_encryption = NULL,
  docker_image = NULL,
  policy_id = NULL,
  kind = c("CLASSIC_PREVIEW"),
  data_security_mode = c("NONE", "SINGLE_USER", "USER_ISOLATION", "LEGACY_TABLE_ACL",
    "LEGACY_PASSTHROUGH", "LEGACY_SINGLE_USER", "LEGACY_SINGLE_USER_STANDARD",
    "DATA_SECURITY_MODE_STANDARD", "DATA_SECURITY_MODE_DEDICATED",
    "DATA_SECURITY_MODE_AUTO"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{Canonical identifier for the cluster.}

\item{spark_version}{The runtime version of the cluster. You can retrieve a
list of available runtime versions by using \code{\link[=db_cluster_runtime_versions]{db_cluster_runtime_versions()}}.}

\item{node_type_id}{The node type for the worker nodes.
\code{\link[=db_cluster_list_node_types]{db_cluster_list_node_types()}} can be used to see available node types.}

\item{num_workers}{Number of worker nodes that this cluster should have. A
cluster has one Spark driver and \code{num_workers} executors for a total of
\code{num_workers} + 1 Spark nodes.}

\item{autoscale}{Instance of \code{\link[=cluster_autoscale]{cluster_autoscale()}}.}

\item{name}{Cluster name requested by the user. This doesn’t have to be
unique. If not specified at creation, the cluster name will be an empty
string.}

\item{spark_conf}{Named list. An object containing a set of optional,
user-specified Spark configuration key-value pairs. You can also pass in a
string of extra JVM options to the driver and the executors via
\code{spark.driver.extraJavaOptions} and \code{spark.executor.extraJavaOptions}
respectively. E.g. \code{list("spark.speculation" = true, "spark.streaming.ui.retainedBatches" = 5)}.}

\item{cloud_attrs}{Attributes related to clusters running on specific cloud
provider. Defaults to \code{\link[=aws_attributes]{aws_attributes()}}. Must be one of \code{\link[=aws_attributes]{aws_attributes()}},
\code{\link[=azure_attributes]{azure_attributes()}}, \code{\link[=gcp_attributes]{gcp_attributes()}}.}

\item{driver_node_type_id}{The node type of the Spark driver. This field is
optional; if unset, the driver node type will be set as the same value as
\code{node_type_id} defined above. \code{\link[=db_cluster_list_node_types]{db_cluster_list_node_types()}} can be used to
see available node types.}

\item{custom_tags}{Named list. An object containing a set of tags for cluster
resources. Databricks tags all cluster resources with these tags in addition
to \code{default_tags}. Databricks allows at most 45 custom tags.}

\item{init_scripts}{Instance of \code{\link[=init_script_info]{init_script_info()}}.}

\item{spark_env_vars}{Named list. User-specified environment variable
key-value pairs. In order to specify an additional set of
\code{SPARK_DAEMON_JAVA_OPTS}, we recommend appending them to
\verb{$SPARK_DAEMON_JAVA_OPTS} as shown in the following example. This ensures
that all default Databricks managed environmental variables are included as
well. E.g. \code{{"SPARK_DAEMON_JAVA_OPTS": "$SPARK_DAEMON_JAVA_OPTS -Dspark.shuffle.service.enabled=true"}}}

\item{autotermination_minutes}{Automatically terminates the cluster after it
is inactive for this time in minutes. If not set, this cluster will not be
automatically terminated. If specified, the threshold must be between 10 and
10000 minutes. You can also set this value to 0 to explicitly disable
automatic termination. Defaults to 120.}

\item{log_conf}{Instance of \code{\link[=cluster_log_conf]{cluster_log_conf()}}.}

\item{ssh_public_keys}{List. SSH public key contents that will be added to each
Spark node in this cluster. The corresponding private keys can be used to
login with the user name ubuntu on port 2200. Up to 10 keys can be specified.}

\item{driver_instance_pool_id}{ID of the instance pool to use for the
driver node. You must also specify \code{instance_pool_id}. Optional.}

\item{instance_pool_id}{ID of the instance pool to use for cluster nodes. If
\code{driver_instance_pool_id} is present, \code{instance_pool_id} is used for worker
nodes only. Otherwise, it is used for both the driver and worker nodes.
Optional.}

\item{idempotency_token}{An optional token that can be used to guarantee the
idempotency of cluster creation requests. If an active cluster with the
provided token already exists, the request will not create a new cluster,
but it will return the ID of the existing cluster instead. The existence of a
cluster with the same token is not checked against terminated clusters. If
you specify the idempotency token, upon failure you can retry until the
request succeeds. Databricks guarantees that exactly one cluster will be
launched with that idempotency token. This token should have at most 64
characters.}

\item{enable_elastic_disk}{When enabled, this cluster will dynamically
acquire additional disk space when its Spark workers are running low on
disk space.}

\item{apply_policy_default_values}{Boolean (Default: \code{TRUE}), whether to use
policy default values for missing cluster attributes.}

\item{enable_local_disk_encryption}{Boolean (Default: \code{TRUE}), whether
encryption of disks locally attached to the cluster is enabled.}

\item{docker_image}{Instance of \code{\link[=docker_image]{docker_image()}}.}

\item{policy_id}{String, ID of a cluster policy.}

\item{kind}{The kind of compute described by this compute specification.}

\item{data_security_mode}{Data security mode decides what data governance
model to use when accessing data from a cluster.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Edit the configuration of a cluster to match the provided attributes and
size.
}
\details{
You can edit a cluster if it is in a \code{RUNNING} or \code{TERMINATED} state. If you
edit a cluster while it is in a \code{RUNNING} state, it will be restarted so that
the new attributes can take effect. If you edit a cluster while it is in a
\code{TERMINATED} state, it will remain \code{TERMINATED.} The next time it is started
using the clusters/start API, the new attributes will take effect. An attempt
to edit a cluster in any other state will be rejected with an \code{INVALID_STATE}
error code.

Clusters created by the Databricks Jobs service cannot be edited.
}
\seealso{
Other Clusters API: 
\code{\link{db_cluster_create}()},
\code{\link{db_cluster_events}()},
\code{\link{db_cluster_get}()},
\code{\link{db_cluster_list}()},
\code{\link{db_cluster_list_node_types}()},
\code{\link{db_cluster_list_zones}()},
\code{\link{db_cluster_perm_delete}()},
\code{\link{db_cluster_pin}()},
\code{\link{db_cluster_resize}()},
\code{\link{db_cluster_restart}()},
\code{\link{db_cluster_runtime_versions}()},
\code{\link{db_cluster_start}()},
\code{\link{db_cluster_terminate}()},
\code{\link{db_cluster_unpin}()},
\code{\link{get_and_start_cluster}()},
\code{\link{get_latest_dbr}()}
}
\concept{Clusters API}
