% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainwater.R
\docType{data}
\name{rainwater}
\alias{rainwater}
\title{rainwater Bayesian Network}
\format{
A discrete Bayesian network to predict if a given short-term time series leads to results similar to those obtained using a long-term time series. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{Representativeness}{(Yes, No);}
\item{SeriesLength}{(One Year, Two Year, Three Year, Four Year, Five Year, Six Year, Seven Year, Eigth Year, Nine Year, Ten Year, Fifteen Year, Twenty Year);}
\item{SeasonalityIndex}{(High, Medium, Low);}
\item{RainwaterDemand}{(Demand 20, Demand 30, Demand 40, Demand 50);}
\item{AverageAnnualRainfall}{(High, Medium, Low);}
\item{AverageNumberOfDryDaysPerYear}{(High, Medium, Low);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Short-term instead of long-term rainfall time series in rainwater harvesting simulation in houses: An assessment using Bayesian Network.
}
\references{
Geraldi, M. S., & Ghisi, E. (2019). Short-term instead of long-term rainfall time series in rainwater harvesting simulation in houses: An assessment using Bayesian Network. Resources, Conservation and Recycling, 144, 1-12.
}
\keyword{TAN}
