#' covidfear Bayesian Network
#'
#' Learning and interpreting asymmetry-labeled DAGs: a case study on COVID-19 fear.
#'
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network to understand the effect of demographic factors on the answers to the COVID-19 fear scale and the relationship between the scale items. The Bayesian network was learned as in the referenced paper. The vertices are:
#' \describe{
#'   \item{Age}{(Young, Adult);}
#'   \item{Gender}{(Female, Male);}
#'   \item{Fear}{I am most afraid of COVID-19 (Disagree, Neither, Agree);}
#'   \item{Think}{It makes me uncomfortable to think about COVID-19 (Disagree, Neither, Agree);}
#'   \item{Hands}{My hands become clammy when I think about COVID-19 (Disagree, Neither, Agree);}
#'   \item{Life}{I fear losing my life because of COVID-19 (Disagree, Neither, Agree);}
#'   \item{News}{I become nervous or anxious when watching news and stories about COVID-19 on social media (Disagree, Neither, Agree);}
#'   \item{Sleep}{I cannot sleep because I am worried about getting COVID-19 (Disagree, Neither, Agree);}
#'   \item{Hearth}{My heart races or palpitates when I think about getting COVID-19 (Disagree, Neither, Agree);}
#' }
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#'
#' @keywords NULL
#' @importClassesFrom bnlearn bn.fit
#' @references Leonelli, M., & Varando, G. (2024). Learning and interpreting asymmetry-labeled DAGs: a case study on COVID-19 fear. Applied Intelligence, 54(2), 1734-1750.
"covidfear"
