% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpy2.r
\name{interpy2}
\alias{interpy2}
\title{A simple linear interpolation function applicable to two vectors
(\eqn{X} and \eqn{Y}), when the second element of \eqn{Y} is missing.}
\usage{
interpy2(xs = xs, ys = ys)
}
\arguments{
\item{xs}{A numeric vector of length 3.}

\item{ys}{A numeric vector of length 3, with the second position empty.}
}
\value{
The interpolated value for the second element of vector \eqn{Y}.
}
\description{
A simple linear interpolation function applicable to two vectors
(e.g., \eqn{X} and \eqn{Y}) of length three, suitable when the second
element of \eqn{Y} is missing.
}
\examples{
x<-c(0.2,0.8,1.3)
y<-c(48,NA,41)
interpy2(xs=x,ys=y)
}
\author{
Christian Salas-Eljatib.
}
