% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scan.R
\name{get_scan}
\alias{get_scan}
\title{Get a scan (\code{scan}) from a polar volume (\code{pvol})}
\usage{
get_scan(x, elev, all = FALSE)
}
\arguments{
\item{x}{A \code{pvol} object.}

\item{elev}{Numeric. Elevation angle in degrees.}

\item{all}{Logical. Return the first scan in the \code{pvol} object
closest to the requested elevation (\code{FALSE}), or a list with
all scans equally close to the requested elevation (\code{TRUE}).}
}
\value{
A \code{scan} object when \code{all} equals \code{FALSE} (default), or a list of \code{scan} objects if \code{all} equals \code{TRUE}
}
\description{
Returns the scan (\code{scan}) from a polar volume (\code{pvol}) with elevation angle
closest to \code{elev}.
}
\details{
In cases where \code{elev} is exactly in between two
scan elevation angles, the lower elevation angle scan is returned.
}
\examples{
# Locate and read the polar volume example file
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")
pvol <- read_pvolfile(pvolfile)

# Get elevation angles
get_elevation_angles(pvol)

# Extract the scan closest to 3 degrees elevation (2.5 degree scan)
scan <- get_scan(pvol, 3)

# Get summary info
scan

# Extract all scans closest to 3 degrees elevation (2.5 degree scan)
# Always returns a list with scan object(s), containing multiple scans
# if the pvol contains multiple scans at the same closest elevation.
scan_list <- get_scan(pvol, 3)
scan_list
}
\seealso{
\itemize{
\item \code{\link[=summary.scan]{summary.scan()}}
\item \code{\link[=get_elevation_angles]{get_elevation_angles()}}
}
}
