% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThresholdDorfman.R
\name{ExpTests.TOD}
\alias{ExpTests.TOD}
\title{Extract the expected number of tests from testing configuration results}
\usage{
\method{ExpTests}{TOD}(object, ...)
}
\arguments{
\item{object}{An object of class "TOD", from which the expected number
of tests is to be extracted.}

\item{...}{Additional arguments to be passed to \code{ExpTests} (e.g.,
\code{digits} to be passed to \code{round} for appropriate rounding).}
}
\value{
A data frame containing the columns:
\item{ExpTests}{the expected number of tests required to decode all individuals
in the algorithm.}
\item{ExpTestsPerIndividual}{the expected number of tests per individual.}
\item{PercentReductionTests}{The percent reduction in the number of tests; 100 * (1 - ExpTestsPerIndividual).}
\item{PercentIncreaseTestCap}{The percent increase in testing capacity when the algorithm
  is applied to a continuous stream of specimens; 100 * (1/ExpTestsPerIndividual - 1).}
}
\description{
Extract the expected number of tests from objects of class "TOD" returned by
\code{\link{TOD}} (\kbd{TOD}).
}
\examples{
set.seed(1002)
p.vec <- expectOrderBeta(p = 0.01, alpha = 2, size = 20)
save.it1 <- TOD(p = p.vec, Se = 0.95, Sp = 0.95, max = 5, threshold = 0.015)
ExpTests(save.it1)
}
\references{
\insertRef{bilder2020tests}{binGroup2}
}
\author{
Christopher R. Bilder
}
