# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

eigenvectors_sparse <- function(X, n_vec) {
    .Call('_bigergm_eigenvectors_sparse', PACKAGE = 'bigergm', X, n_vec)
}

#' Compute Yule's Phi-coefficient
#' @description 
#' This function computes Yule's Phi-coefficient between the true and estimated block membership (its definition can be found here \url{https://en.wikipedia.org/wiki/Phi_coefficient}).
#' In this context, the Phi Coefficient is a measure of association between two group membership vectors. 
#' @param z_star a true block membership
#' @param z an estimated block membership
#' @export
#' @return Real value of Yule's Phi-coefficient between the true and estimated block membership is returned.
#' @examples
#' data(toyNet)
#' yule(z_star = toyNet%v% "block",
#'                   z = sample(c(1:4),size = 200,replace = TRUE))
#'                   
yule <- function(z_star, z) {
    .Call('_bigergm_yule', PACKAGE = 'bigergm', z_star, z)
}

decimal_to_binary_vector <- function(decimal, vec_length) {
    .Call('_bigergm_decimal_to_binary_vector', PACKAGE = 'bigergm', decimal, vec_length)
}

compute_sumTaus <- function(numOfVertices, numOfClasses, tau, verbose = 0L) {
    .Call('_bigergm_compute_sumTaus', PACKAGE = 'bigergm', numOfVertices, numOfClasses, tau, verbose)
}

compute_quadratic_term_naive <- function(numOfVertices, numOfClasses, pi, tau, network) {
    .Call('_bigergm_compute_quadratic_term_naive', PACKAGE = 'bigergm', numOfVertices, numOfClasses, pi, tau, network)
}

compute_linear_term <- function(numOfVertices, numOfClasses, alpha, tau, LB) {
    .Call('_bigergm_compute_linear_term', PACKAGE = 'bigergm', numOfVertices, numOfClasses, alpha, tau, LB)
}

compute_pi <- function(numOfVertices, numOfClasses, stat, tau) {
    .Call('_bigergm_compute_pi', PACKAGE = 'bigergm', numOfVertices, numOfClasses, stat, tau)
}

compute_quadratic_term <- function(numOfVertices, numOfClasses, alpha, tau, network, LB, verbose = 0L) {
    .Call('_bigergm_compute_quadratic_term', PACKAGE = 'bigergm', numOfVertices, numOfClasses, alpha, tau, network, LB, verbose)
}

compute_quadratic_term_directed <- function(numOfVertices, numOfClasses, alpha, tau, network, LB, verbose = 0L) {
    .Call('_bigergm_compute_quadratic_term_directed', PACKAGE = 'bigergm', numOfVertices, numOfClasses, alpha, tau, network, LB, verbose)
}

run_MM_without_features <- function(numOfVertices, numOfClasses, alpha, tau, network, verbose = 0L, directed = FALSE) {
    .Call('_bigergm_run_MM_without_features', PACKAGE = 'bigergm', numOfVertices, numOfClasses, alpha, tau, network, verbose, directed)
}

compute_denominator_for_pi_d1x0 <- function(numOfVertices, numOfClasses, matrix_for_denominator, tau, verbose) {
    .Call('_bigergm_compute_denominator_for_pi_d1x0', PACKAGE = 'bigergm', numOfVertices, numOfClasses, matrix_for_denominator, tau, verbose)
}

compute_pi_d1x0 <- function(numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau, verbose) {
    .Call('_bigergm_compute_pi_d1x0', PACKAGE = 'bigergm', numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau, verbose)
}

compute_quadratic_term_with_features <- function(numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau, LB, verbose = 0L) {
    .Call('_bigergm_compute_quadratic_term_with_features', PACKAGE = 'bigergm', numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau, LB, verbose)
}

compute_quadratic_term_with_features_directed <- function(numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau, LB, verbose = 0L) {
    .Call('_bigergm_compute_quadratic_term_with_features_directed', PACKAGE = 'bigergm', numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau, LB, verbose)
}

compute_pi_with_features <- function(numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau) {
    .Call('_bigergm_compute_pi_with_features', PACKAGE = 'bigergm', numOfVertices, numOfClasses, list_multiplied_feature_adjmat, tau)
}

run_MM_with_features <- function(numOfVertices, numOfClasses, alpha, list_multiplied_feature_adjmat, tau, verbose = 0L, directed = FALSE) {
    .Call('_bigergm_run_MM_with_features', PACKAGE = 'bigergm', numOfVertices, numOfClasses, alpha, list_multiplied_feature_adjmat, tau, verbose, directed)
}

simulate_between_network <- function(numOfVertices, list_feature_adjmat, coef_between, block_membership, directed, seed) {
    .Call('_bigergm_simulate_between_network', PACKAGE = 'bigergm', numOfVertices, list_feature_adjmat, coef_between, block_membership, directed, seed)
}

simulate_between_network_covariates <- function(numOfVertices, coef_between, list_feature_adjmat, block_membership, directed, seed) {
    .Call('_bigergm_simulate_between_network_covariates', PACKAGE = 'bigergm', numOfVertices, coef_between, list_feature_adjmat, block_membership, directed, seed)
}

simulate_between_network_no_covariates <- function(numOfVertices, coef_between, block_membership, directed, seed) {
    .Call('_bigergm_simulate_between_network_no_covariates', PACKAGE = 'bigergm', numOfVertices, coef_between, block_membership, directed, seed)
}

