% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerbinbf01.R
\name{powerbinbf01}
\alias{powerbinbf01}
\title{Power and sample size calculations for binomial Bayes factor}
\usage{
powerbinbf01(
  n = NULL,
  power = NULL,
  k = 1/10,
  p0 = 0.5,
  type = c("point", "direction"),
  a = 1,
  b = 1,
  dp = NA,
  da = a,
  db = b,
  dl = 0,
  du = 1,
  nrange = c(1, 10^4)
)
}
\arguments{
\item{n}{Sample size. Has to be \code{NULL} if \code{power} is specified.
Defaults to \code{NULL}}

\item{power}{Target power. Has to be \code{NULL} if \code{n} is specified.
Defaults to \code{NULL}}

\item{k}{Bayes factor threshold. Defaults to \code{1/10}, Jeffreys' threshold
for 'strong evidence' against the null hypothesis}

\item{p0}{Tested binomial proportion. Defaults to \code{0.5}}

\item{type}{Type of test. Can be \code{"point"} or \code{"directional"}.
Defaults to \code{"point"}}

\item{a}{Number of successes parameter of the beta analysis prior
distribution. Defaults to \code{1}}

\item{b}{Number of failures parameter of the beta analysis prior
distribution. Defaults to \code{1}}

\item{dp}{Fixed binomial proportion assumed for the power calculation. Set to
\code{NA} to use a truncated beta design prior instead (specified via the
\code{da}, \code{db}, \code{dl}, and \code{du} arguments). Defaults to
\code{NA}}

\item{da}{Number of successes parameter of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
the same value \code{a} as specified for the analysis prior}

\item{db}{Number of failures parameter of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
the same value \code{b} as specified for the analysis prior}

\item{dl}{Lower truncation limit of of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
\code{0}}

\item{du}{Upper truncation limit of of the truncated beta design prior
distribution. Is only taken into account if \code{dp = NA}. Defaults to
\code{1}}

\item{nrange}{Sample size search range over which numerical search is
performed (only taken into account when \code{n} is \code{NULL}).
Defaults to \code{c(1, 10^3)}}
}
\value{
Object of class \code{"power.bftest"}, a list of the arguments
    (including the computed one) augmented with \code{method} and \code{note}
    elements
}
\description{
Compute probability that binomial Bayes factor (\link{binbf01})
    is smaller than a specified threshold (the power), or determine sample
    size to obtain a target power.
}
\details{
This function provides a similar interface as
    \code{stats::power.prop.test}. For some users, the low-level functions
    \link{nbinbf01} (to directly compute the sample size for a fixed power)
    and \link{pbinbf01} (to directly compute the power for a fixed sample
    size) may also be useful.
}
\examples{
## determine sample size
(nres <- powerbinbf01(power = 0.8, p0 = 0.2, type = "direction", dl = 0.2))
\dontrun{
plot(nres, nlim = c(1, 250), ngrid = 250, type = "s")
}

## determine power
(powres <- powerbinbf01(n = 100, type = "point"))
\dontrun{
plot(powres)
}

}
\seealso{
\link{plot.power.bftest}, \link{pbinbf01}, \link{nbinbf01},
    \link{binbf01}
}
\author{
Samuel Pawel
}
