% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfastlite.R
\name{plot.bfastlite}
\alias{plot.bfastlite}
\title{Plot the time series and results of BFAST Lite}
\usage{
\method{plot}{bfastlite}(x, breaks = NULL, magstat = NULL, magcomp = "trend", ...)
}
\arguments{
\item{x}{bfastlite object from \code{\link[=bfastlite]{bfastlite()}}}

\item{breaks}{number of breaks or optimal break selection method, see \code{\link[strucchangeRcpp:breakpoints]{strucchangeRcpp::breakpoints()}}}

\item{magstat}{name of the magnitude column to plot (e.g. \code{RMSD}, \code{MAD}, \code{diff}), see the \code{Mag} component of \code{\link[strucchangeRcpp:magnitude]{strucchangeRcpp::magnitude.breakpointsfull()}}}

\item{magcomp}{name of the component (i.e. column in \code{x$data_pp}) to plot magnitudes of}

\item{...}{other parameters to pass to \code{\link[=plot]{plot()}}}
}
\value{
Nothing, called for side effects.
}
\description{
The black line represents the original input data,
the green line is the fitted model,
the blue lines are the detected breaks, and
the whiskers denote the magnitude (if \code{magstat} is specified).
}
