% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-httpRouters.R
\name{httpGET}
\alias{httpGET}
\title{GET-binding middleware}
\usage{
httpGET(beakr, path = NULL, FUN = NULL)
}
\arguments{
\item{beakr}{\code{Beakr} instance or \code{NULL}.}

\item{path}{String representing a path for which the middleware
function is invoked.}

\item{FUN}{Middleware function to be invoked.}
}
\value{
A \code{Beakr} instance with added middleware.
}
\description{
Routes HTTP GET requests to the specified path with the
specified callback functions or middleware.
}
\examples{
\dontrun{
library(beakr)

# Create an new Beakr instance
beakr <- newBeakr()

# Create a simple beakr pipeline
beakr \%>\%
  httpGET("/", function(req, res, err) {
    return("Successful GET request!\n")
  }) \%>\%
  listen(host = '127.0.0.1', port = 25118, daemon = TRUE)

# ------------------------------------------------------------
# IN A TERMINAL:
#  curl -X GET http://127.0.0.1:25118/
# > Successful GET request!
# ------------------------------------------------------------

# Stop the beakr instance server
stopServer(beakr)
}
}
