% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curveFunctions.R
\name{polynomial}
\alias{polynomial}
\title{Polynomial curve function for nlme}
\usage{
polynomial(dat, y, time, degree, raw = TRUE, params = NULL, ...)
}
\arguments{
\item{dat}{subject data to be used}

\item{y}{outcome variable}

\item{time}{time variable}

\item{degree}{degree of polynomial}

\item{raw}{Boolean, use raw polynomials?}

\item{params}{\code{NULL} unless user wants to specify starting parameters for gnls}

\item{...}{just in case}
}
\description{
Polynomial function used in fitting nlme curve for observations
}
\details{
It's recommended that one uses raw polynomials for this function for
numerical stability. As inference is not performed on the parameters themselves,
this should have minimial consequences

\code{y ~ mini + (peak - mini) / (1 + exp(4 * slope * (cross - (time)) / (peak - mini)))}
}
