% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcp.R
\name{makeConnectArgs}
\alias{makeConnectArgs}
\title{Create a named list of connection arguments to translate to bcp and
sqlcmd options}
\usage{
makeConnectArgs(
  server,
  database,
  username,
  password,
  trustedconnection = TRUE,
  trustservercert = FALSE,
  azure = FALSE,
  quotedidentifiers = FALSE
)
}
\arguments{
\item{server}{the instance of SQL Server to which to connect}

\item{database}{specifies the database to connect to}

\item{username}{login ID}

\item{password}{password for login ID}

\item{trustedconnection}{use integrated security, username and password are not required}

\item{trustservercert}{trust the server certificate, must be \code{FALSE} for 'bcp' utility
versions that are less than 18.0}

\item{azure}{use Azure Active Directory authentication, does not work with integrated
authentication.}

\item{quotedidentifiers}{set QUOTED_IDENTIFIERS option to 'ON' for the connection between bcp/sqlcmd
and SQL Server.}
}
\value{
a list with connection arguments
}
\description{
Create a named list of connection arguments to translate to bcp and
sqlcmd options
}
