% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerAsync.R
\name{OptimizerAsync}
\alias{OptimizerAsync}
\title{Asynchronous Optimizer}
\description{
The \link{OptimizerAsync} implements the asynchronous optimization algorithm.
The optimization is performed asynchronously on a set of workers.
}
\details{
\link{OptimizerAsync} is the abstract base class for all asynchronous optimizers.
It provides the basic structure for asynchronous optimization algorithms.
The public method \verb{$optimize()} is the main entry point for the optimization and runs in the main process.
The method starts the optimization process by starting the workers and pushing the necessary objects to the workers.
Optionally, a set of points can be created, e.g. an initial design, and pushed to the workers.
The private method \verb{$.optimize()} is the actual optimization algorithm that runs on the workers.
Usually, the method proposes new points, evaluates them, and updates the archive.
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerAsync}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerAsync-optimize}{\code{OptimizerAsync$optimize()}}
\item \href{#method-OptimizerAsync-clone}{\code{OptimizerAsync$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="initialize"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-initialize'><code>bbotk::Optimizer$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerAsync-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerAsync-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the optimization on a \link{OptimInstanceAsyncSingleCrit} or \link{OptimInstanceAsyncMultiCrit} until termination.
The single evaluations will be written into the \link{ArchiveAsync}.
The result will be written into the instance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerAsync$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{OptimInstanceAsyncSingleCrit} | \link{OptimInstanceAsyncMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerAsync-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerAsync-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerAsync$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
