% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R, R/print.R, R/print_html.R,
%   R/print_md.R
\name{display.describe_posterior}
\alias{display.describe_posterior}
\alias{print.describe_posterior}
\alias{print_html.describe_posterior}
\alias{print_md.describe_posterior}
\title{Print tables in different output formats}
\usage{
\method{display}{describe_posterior}(object, format = "markdown", ...)

\method{print}{describe_posterior}(x, digits = 2, caption = "Summary of Posterior Distribution", ...)

\method{print_html}{describe_posterior}(x, digits = 2, caption = "Summary of Posterior Distribution", ...)

\method{print_md}{describe_posterior}(x, digits = 2, caption = "Summary of Posterior Distribution", ...)
}
\arguments{
\item{object, x}{An object returned by one of the package's function, for
example \code{\link[=describe_posterior]{describe_posterior()}}, \code{\link[=point_estimate]{point_estimate()}}, or \code{\link[=eti]{eti()}}.}

\item{format}{String, indicating the output format. Can be \code{"markdown"}
\code{"html"}, or \code{"tt"}. \code{format = "tt"} creates a \code{tinytable} object, which is
either printed as markdown or HTML table, depending on the environment. See
\code{\link[insight:export_table]{insight::export_table()}} for details.}

\item{...}{Arguments passed down to \code{print_html()} or \code{print_md()} (e.g.,
\code{digits}), or to \code{insight::export_table()}.}

\item{digits}{Integer, number of digits to round the table output. Defaults
to 2.}

\item{caption}{Character, caption for the table. If \code{NULL}, no caption is
added. By default, a caption is created based on the object type.}
}
\value{
If \code{format = "markdown"}, the return value will be a character
vector in markdown-table format. If \code{format = "html"}, an object of
class \code{gt_tbl}. If \code{format = "tt"}, an object of class \code{tinytable}.
}
\description{
Prints tables (i.e. data frame) in different output formats.
}
\details{
\code{display()} is useful when the table-output from functions, which is
usually printed as formatted text-table to console, should be formatted for
pretty table-rendering in markdown documents, or if knitted from rmarkdown
to PDF or Word files. See
\href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{vignette}
for examples.
}
\examples{
\dontshow{if (all(insight::check_if_installed(c("tinytable", "gt"), quietly = TRUE))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
d <- data.frame(replicate(4, rnorm(20)))
result <- describe_posterior(d)

# markdown format
display(result)

# gt HTML
display(result, format = "html")

# tinytable
display(result, format = "tt")
}
\dontshow{\}) # examplesIf}
}
