% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnecfit-methods.R
\name{+.bnecfit}
\alias{+.bnecfit}
\title{"Add" multiple \code{\link{bnecfit}} objects into one single
\code{\link{bayesmanecfit}} object containing Bayesian model averaging
statistics.}
\usage{
\method{+}{bnecfit}(e1, e2)
}
\arguments{
\item{e1}{An object of class \code{\link{bnecfit}}.}

\item{e2}{An object of class \code{\link{bnecfit}}.}
}
\value{
An object of class \code{\link{bayesmanecfit}}.
}
\description{
"Add" multiple \code{\link{bnecfit}} objects into one single
\code{\link{bayesmanecfit}} object containing Bayesian model averaging
statistics.
}
\examples{
\dontrun{
library(bayesnec)
nec4param <- pull_out(manec_example, model = "nec4param")
ecx4param <- pull_out(manec_example, model = "ecx4param")
# Go from two bayesnecfit objects to a bayesmanecfit object.
#   In this example case it is redundant because it recovers the original
#   `manec_example`.
nec4param + ecx4param
# Add a bayesnecfit object to an existing bayesmanecfit object
nechorme4 <- nec_data |>
  dplyr::mutate(y = qlogis(y)) |>
  (\(.)bnec(formula = y ~ crf(x, model = "nechorme4"),
            data = ., iter = 200, warmup = 150, chains = 2,
            stan_model_args = list(save_dso = FALSE)))()
nechorme4 + manec_example
}

}
