% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestHillModel.R
\name{estimateBIC}
\alias{estimateBIC}
\title{Estimate Bayesian Information Criterion}
\usage{
estimateBIC(resid, npar)
}
\arguments{
\item{resid}{A vector of residuals from a given fit}

\item{npar}{The number of paramters in the model}
}
\value{
The Bayesian informtion criterion (BIC) value for the fit
}
\description{
Estimate Bayesian Information Criterion
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,75)
response <- evalHillModel(conc, hpar) + rnorm(length(conc),sd=7.5)

hfit4p <- fitHillModel(conc,response,c(1,2,3,4),start=c(0.5,1,0,100))
hfit3p <- fitHillModel(conc,response,c(1,2,4),start=c(0.5,1,0,100))

aic4p <- estimateBIC(residuals(hfit4p),4)
aic3p <- estimateBIC(residuals(hfit3p),3)
}
