% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdsBart.R
\name{mdsBart}
\alias{mdsBart}
\title{mdsBart}
\usage{
mdsBart(
  trees,
  data,
  target,
  response,
  plotType = "rows",
  showGroup = TRUE,
  level = 0.95
)
}
\arguments{
\item{trees}{A data frame created by `extractTreeData` function.}

\item{data}{a dataframe used in building the model.}

\item{target}{A target proximity matrix to}

\item{response}{The name of the response for the fit.}

\item{plotType}{Type of plot to show. Either 'interactive' - showing interactive confidence ellipses.
'point' - a point plot showing the average position of a observation.
'rows' - displaying the average position of a observation number instead of points.
'all' - show all observations (not averaged).}

\item{showGroup}{Logical. Show confidence ellipses.}

\item{level}{The confidence level to show. Default is 95\% confidence level.}
}
\value{
For this function, the MDS coordinates are calculated for each iteration.
Procrustes method is then applied to align each of the coordinates to a target set
of coordinates. The returning result is then a clustered average of each point.
}
\description{
Multi-dimensional Scaling Plot of proximity matrix from a BART model.
}
\examples{
if (requireNamespace("dbarts", quietly = TRUE)) {
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6],
   df[, 1],
   ntree = 5,
   keeptrees = TRUE,
   nskip = 10,
   ndpost = 10
 )
 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 # Cretae Porximity Matrix
 bmProx <- proximityMatrix(
   trees = trees_data,
   reorder = TRUE,
   normalize = TRUE,
   iter = 1
 )
 # MDS plot
 mdsBart(
   trees = trees_data, data = df, target = bmProx,
   plotType = "interactive", level = 0.25, response = "Ozone"
 )
}

}
