% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localProcedure.R
\name{localProcedure}
\alias{localProcedure}
\title{localProcedure}
\usage{
localProcedure(
  model,
  data,
  response,
  numRep = 10,
  numTreesRep = NULL,
  alpha = 0.5,
  shift = FALSE
)
}
\arguments{
\item{model}{Model created from either the BART, dbarts or bartMachine packages.}

\item{data}{A data frame containing variables in the model.}

\item{response}{The name of the response for the fit.}

\item{numRep}{The number of replicates to perform for the BART null model's variable inclusion proportions.}

\item{numTreesRep}{The number of trees to be used in the replicates.
As suggested by Chipman (2009), a small number of trees is recommended (~20) to force important
variables to used in the model. If NULL, then the number of trees from the true model is used.}

\item{alpha}{The cut-off level for the thresholds.}

\item{shift}{Whether to shift the inclusion proportion points by the difference
in distance between the quantile and the value of the inclusion proportion point.}
}
\value{
A variable selection plot using the local procedure method.
}
\description{
A variable selection approach performed by permuting the response.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
# Load the dbarts package to access the bart function
library(dbarts)

# Get Data
df <- na.omit(airquality)
# Create Simple dbarts Model For Regression:
set.seed(1701)
dbartModel <- bart(df[2:6], df[,1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)
localProcedure(model = dbartModel,
               data = df,
               numRep = 5,
               numTreesRep = 5,
               alpha = 0.5,
               shift = FALSE)
}


}
