% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{json_to_sf}
\alias{json_to_sf}
\title{Convert 'Azure Maps' JSON Response to an sf Object}
\usage{
json_to_sf(body, main_route = TRUE, linestring = TRUE)
}
\arguments{
\item{body}{A list, typically the parsed JSON response from an httr2 request.}

\item{main_route}{A logical value. If \code{TRUE} (the default), only the main
route is processed. If \code{FALSE}, alternative routes are processed instead.}

\item{linestring}{A logical value. If \code{TRUE} (the default), it filters for
LineString geometries (the route path).}
}
\value{
An \code{sf} object containing the spatial features from the route response,
or \code{NULL} if no valid features are found.
}
\description{
This function processes a JSON response body from the Azure Maps API,
extracts the route information, and converts it into a spatial (\code{sf}) object.
}
\examples{
\dontrun{
# Assuming 'resp' is an httr2 response object from req_route_directions
body <- httr2::resp_body_json(resp)
route_sf <- json_to_sf(body)
plot(sf::st_geometry(route_sf))
}
}
