% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendix.R
\name{initialize_doc_original}
\alias{initialize_doc_original}
\title{Initialize PowerPoint Document Object}
\usage{
initialize_doc_original(doc_original, doc_o)
}
\arguments{
\item{doc_original}{An existing `officer::rpptx` object, or `NULL` to read from file.}

\item{doc_o}{Path to a PowerPoint (`.pptx`) file. Used only if `doc_original` is `NULL`.}
}
\value{
An `officer::rpptx` PowerPoint object.
}
\description{
This function ensures a PowerPoint document (`officer::rpptx` object) is loaded.
If a `doc_original` is provided, it is directly returned. Otherwise, the function reads
the presentation from the given file path.
}
\examples{
example <- tempfile(fileext = ".pptx")
doc <- officer::read_pptx()
doc <- officer::add_slide(doc, layout = "Title and Content")
print(doc, target = example)
doc <- initialize_doc_original(NULL, example)
}
