% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{filter_spec}
\alias{filter_spec}
\title{Filter a spec object}
\usage{
filter_spec(spec, filter_expr, verbose = TRUE)
}
\arguments{
\item{spec}{A `spec` object as returned by `read_spec()`}

\item{filter_expr}{A `logical` expression indicating outputs to keep}

\item{verbose}{Should a message about the number of outputs matching
`filter_spec` be printed? Defaults to `TRUE`.}
}
\value{
A `spec` object containing only the outputs matching `filter_expr`
}
\description{
Filter a spec object
}
\examples{
library(dplyr)
spec_file <- system.file("spec.yml", package = "autoslider.core")
spec <- spec_file \%>\% read_spec()

## Keep only the t_dm_IT output
filter_spec(spec, output == "t_dm_IT")

## Same as above but more verbose
filter_spec(spec, program == "t_dm" && suffix == "IT")

## Keep all t_ae outputs
filter_spec(spec, program == "t_ae")

## Keep all output run on safety population
filter_spec(spec, "SE" \%in\% suffix)

## Keep t_dm_CHN_IT and t_dm_CHN_SE
filter_spec(spec, program == "t_dm" && suffix \%in\% c("CHN_IT", "CHN_SE"))

## Keep all tables
filter_spec(spec, grepl("^t_", program))

}
\author{
Thomas Neitmann (`neitmant`)
}
