% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_manynet.R
\name{map_measure}
\alias{map_measure}
\alias{plot.node_measure}
\alias{plot.tie_measure}
\alias{plot.network_measures}
\title{Plotting logical marks
Plotting numeric measures}
\usage{
\method{plot}{node_measure}(x, type = c("h", "d"), ...)

\method{plot}{tie_measure}(x, type = c("h", "d"), ...)

\method{plot}{network_measures}(x, ...)
}
\arguments{
\item{x}{An object of "node_measure", "tie_measure",
or "network_measures" class.}

\item{type}{For node and tie measures, whether the plot should be
"h" a histogram or "d" a density plot. By default "h".}

\item{...}{Other arguments to be passed on.}
}
\value{
\code{plot.node_measure()} and \code{plot.tie_measure()} returns a histogram
and/or density plot of the distribution of the measure.

\code{plot.network_measures()} returns a plot of the measure traced over
time.
}
\description{
These functions plot distributions for node, tie, and network measures,
as defined in the \code{{manynet}} package.
}
\examples{
plot(manynet::node_deg(ison_karateka))
plot(manynet::tie_betweenness(ison_karateka))
}
