% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.Genepop.R
\name{read.Genepop}
\alias{read.Genepop}
\title{Read GENEPOP format file}
\usage{
read.Genepop(x, pop.names = NULL, haploid = FALSE, pos = 1)
}
\arguments{
\item{x}{GENEPOP file or path to the file. The filename extension (e.g., .txt) should be included.}

\item{pop.names}{A character string vector for population names. The order of the name should be the same with the order (top to down) in your GENEPOP file.}

\item{haploid}{A logical variable (TRUE or FALSE) to specify whether your dataset is haploid data. Default is FALSE.}

\item{pos}{A parameter for program development use; users can ignore it.}
}
\value{
This function returns a list comprising three elements. 1. YOU_NAME_IT$DataMatrix: A matrix of genetic data with a population name label ($popNameVector) in the last column. 2. YOU_NAME_IT$SampleID: A vector of sample ID. 3. YOU_NAME_IT$LocusName: A vector of locus name.
}
\description{
This function allows you to import a GENEPOP format file into R. Population names can be specified in the argument. See http://genepop.curtin.edu.au/help_input.html for details about GENEPOP format.
}
\examples{
# infile <- read.Genepop("Your_Genepop_File.txt", pop.names=c("pop_A", "pop_B", "pop_C"))
}
\references{
Rousset, F. 2008. Genepop'007: a complete reimplementation of the Genepop software for Windows and Linux. Mol. Ecol. Resources 8: 103-106
}
