% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_bounce.R
\name{seq_bounce}
\alias{seq_bounce}
\title{Bouncing Sequence Generation}
\usage{
seq_bounce(start_n = NULL, end_n = NULL, length = NULL, by = 1)
}
\arguments{
\item{start_n}{The lower (min) numeric bound of the sequence to be generated. Must be \verb{< end_n}.}

\item{end_n}{The upper (max) numeric bound of the sequence to be generated. Must be \verb{> start_n}.}

\item{length}{The desired length of the generated sequence.}

\item{by}{The number increment of the sequence.}
}
\value{
A numeric vector
}
\description{
Generate a regular sequence that 'bounces' between the provided \code{start_n} and \code{end_n} values in increments by the \code{by} value for the length of the \code{length} value provided.
}
\examples{

#By default, seq_bounce creates sequences by increments of 1
#The length argument accepts any positive integer
seq_bounce(start_n = 1, end_n = 5, length = 15)

#The by argument accepts any positive numeric
seq_bounce(start_n = 0, end_n = 10, length = 30, by = .247)

#The end_n value must be greater than the start_n value
#This will give you an error
try(seq_bounce(start_n = 0, end_n = -10, length = 15))

#Instead, reverse the values
seq_bounce(start_n = -10, end_n = 0, length = 15)

}
