% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packer.R
\name{packer}
\alias{packer}
\title{Data Generation for Circle Packing}
\usage{
packer(
  n,
  min_x = 0,
  max_x = 100,
  min_y = 0,
  max_y = 100,
  big_r = 5,
  med_r = 3,
  small_r = 1,
  color_pal = NULL,
  color_type = "regular",
  circle_type = "whole"
)
}
\arguments{
\item{n}{The total number of circles you would like the function to attempt to create. A single numeric value with a minimum value of 10.}

\item{min_x}{The minimum limit of the x-axis - the left 'border' of the canvas A single numeric value.}

\item{max_x}{The maximum limit of the x-axis - the right 'border' of the canvas A single numeric value.}

\item{min_y}{The minimum limit of the y-axis - the bottom 'border' of the canvas A single numeric value.}

\item{max_y}{The maximum limit of the y-axis - the top 'border' of the canvas A single numeric value.}

\item{big_r}{The radius used for your 'big' sized circles A single numeric value.}

\item{med_r}{The radius used for your 'medium' sized circles. A single numeric value.}

\item{small_r}{The radius used for your 'small' sized circles. A single numeric value.}

\item{color_pal}{A vector of hex color codes that will be mapped to the data.}

\item{color_type}{Default is "regular" - The colors will be mapped in order from big circles to small circles. "reverse" - The colors will be mapped in reversed order from small to big circles. "random" - The colors will be mapped randomly to any sized circle.}

\item{circle_type}{Default is "whole" - Regular circles. "swirl" - circles are replaced with spirals. Spirals should be mapped with \code{geom_path} in a ggplot for the best results.}
}
\value{
A Tibble
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A tool for creating a data frame of values that create a circle packing design when plotted.
When the default \code{circle_type} "whole" is used, the output should mapped with \code{geom_polygon}
in a ggplot. When "swirl" is used, the output should be mapped with \code{geom_path} for the best results.
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
\dontshow{\}) # examplesIf}

library(ggplot2)
set.seed(0310)
packed_circles <- packer(
  n = 50, big_r = 5, med_r = 3, small_r = 1,
  min_x = 0, max_x = 100, min_y = 0, max_y = 100
)
packed_circles

packed_circles |>
  ggplot(aes(x, y, group = group)) +
  theme_void() +
  theme(plot.background = element_rect(fill = "black")) +
  geom_polygon(fill = "white", color = "red") +
  coord_equal()

}
